<?php
/**
 * Smart SEO Audit License Server - Configuration
 * Store outside web root or restrict access via .htaccess
 */

declare(strict_types=1);

// Prevent direct access
if (!defined('LICENSE_SERVER')) {
    define('LICENSE_SERVER', true);
}

return [
    // Database
    'db' => [
        'host'     => 'localhost',
        'name'     => 'smart_seo_license',
        'user'     => 'your_db_user',
        'password' => 'your_db_password',
        'charset'  => 'utf8mb4',
    ],

    // Envato API
    'envato' => [
        'personal_token' => 'YOUR_ENVATO_PERSONAL_TOKEN',
        'item_id'        => 'YOUR_ITEM_ID', // e.g. 12345678
    ],

    // API secret key - plugin must send this in X-Api-Key header or api_key POST
    'api_secret_key' => 'GENERATE_A_STRONG_RANDOM_32_CHAR_KEY',

    // Rate limiting: max requests per IP per hour (per endpoint type)
    'rate_limit' => 60,

    // Session (for admin)
    'session' => [
        'name'     => 'SSA_LICENSE_ADMIN',
        'lifetime' => 3600,
    ],
];
