-- Smart SEO Audit License Server - Database Schema
-- Run this after creating the database

CREATE DATABASE IF NOT EXISTS smart_seo_license
  DEFAULT CHARACTER SET utf8mb4
  COLLATE utf8mb4_unicode_ci;

USE smart_seo_license;

-- Licenses table
CREATE TABLE IF NOT EXISTS licenses (
  id                  INT UNSIGNED NOT NULL AUTO_INCREMENT,
  purchase_code_hash  VARCHAR(64)  NOT NULL,
  domain              VARCHAR(255) NOT NULL,
  email               VARCHAR(255) NOT NULL,
  status              ENUM('active', 'revoked', 'blocked') NOT NULL DEFAULT 'active',
  activation_date     DATETIME     NOT NULL DEFAULT CURRENT_TIMESTAMP,
  last_check          DATETIME     NULL ON UPDATE CURRENT_TIMESTAMP,
  ip_address          VARCHAR(45)  NULL,
  created_at          DATETIME     NOT NULL DEFAULT CURRENT_TIMESTAMP,
  updated_at          DATETIME     NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (id),
  UNIQUE KEY uq_domain (domain),
  KEY idx_purchase_hash (purchase_code_hash),
  KEY idx_status (status),
  KEY idx_email (email)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Blocked domains (block without revoking license)
CREATE TABLE IF NOT EXISTS blocked_domains (
  id         INT UNSIGNED NOT NULL AUTO_INCREMENT,
  domain     VARCHAR(255) NOT NULL,
  reason     VARCHAR(255) NULL,
  blocked_at DATETIME     NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (id),
  UNIQUE KEY uq_domain (domain)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Rate limiting log
CREATE TABLE IF NOT EXISTS rate_limit_log (
  id         INT UNSIGNED NOT NULL AUTO_INCREMENT,
  ip_address VARCHAR(45) NOT NULL,
  endpoint   VARCHAR(64) NOT NULL,
  request_at DATETIME    NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (id),
  KEY idx_ip_endpoint (ip_address, endpoint),
  KEY idx_request_at (request_at)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Admin users (for dashboard login)
CREATE TABLE IF NOT EXISTS admin_users (
  id            INT UNSIGNED NOT NULL AUTO_INCREMENT,
  username      VARCHAR(64)  NOT NULL,
  password_hash VARCHAR(255) NOT NULL,
  created_at    DATETIME     NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (id),
  UNIQUE KEY uq_username (username)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Default admin: username 'admin', password 'change_me_immediately'
INSERT INTO admin_users (username, password_hash) VALUES
  ('admin', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi')
ON DUPLICATE KEY UPDATE username = username;
