<?php
/**
 * Deactivate endpoint: remove license activation for domain
 * POST: domain (+ api_key or X-Api-Key header)
 */

declare(strict_types=1);

define('LICENSE_SERVER', true);

require __DIR__ . '/includes/bootstrap.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    json_response(['error' => 'Method not allowed', 'status' => 'invalid'], 405);
}

if (!validate_api_key($config)) {
    json_response(['error' => 'Invalid API key', 'status' => 'invalid'], 403);
}

check_rate_limit($pdo, $config, 'deactivate');

$domain = isset($_POST['domain']) ? trim((string) $_POST['domain']) : '';
$domain = preg_replace('/^https?:\/\//i', '', $domain);
$domain = strtolower(explode('/', $domain)[0]);

if (!preg_match('/^[a-z0-9]([a-z0-9\-\.]*[a-z0-9])?$/i', $domain) || strlen($domain) > 255) {
    json_response(['error' => 'Invalid domain', 'status' => 'invalid'], 400);
}

$stmt = $pdo->prepare('UPDATE licenses SET status = \'revoked\' WHERE domain = ?');
$stmt->execute([$domain]);

if ($stmt->rowCount() > 0) {
    json_response(['status' => 'deactivated', 'message' => 'License deactivated for domain']);
}

json_response(['status' => 'deactivated', 'message' => 'No active license found for this domain']);
